﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="WsdlHelpGenerator.aspx.cs" Inherits="ccPublisherWeb.WebServices.WsdlHelpGenerator" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
   <link rel="alternate" type="text/xml" href='<%#Uri.EscapeUriString(Request.Path).Replace("#", "%23") + "?disco"%>'/>

   <style type="text/css">
      BODY { <%#GetLocalizedText("StyleBODY")%> }
      #content { <%#GetLocalizedText("Stylecontent")%> }
      A:link { <%#GetLocalizedText("StyleAlink")%> }
      A:visited { <%#GetLocalizedText("StyleAvisited")%> }
      A:active { <%#GetLocalizedText("StyleAactive")%> }
      A:hover { <%#GetLocalizedText("StyleAhover")%> }
      P { <%#GetLocalizedText("StyleP")%> }
      pre { <%#GetLocalizedText("Stylepre")%> }
      td { <%#GetLocalizedText("Styletd")%> }
      h2 { <%#GetLocalizedText("Styleh2")%> }
      h3 { <%#GetLocalizedText("Styleh3")%> }
      ul { <%#GetLocalizedText("Styleul")%> }
      ol { <%#GetLocalizedText("Styleol")%> }
      li { <%#GetLocalizedText("Styleli")%> }
      font.value { <%#GetLocalizedText("Stylefontvalue")%> }
      font.key { <%#GetLocalizedText("Stylefontkey")%> }
      font.error { <%#GetLocalizedText("StylefontError")%> }
      .heading1 { <%#GetLocalizedText("Styleheading1")%> }
      .button { <%#GetLocalizedText("Stylebutton")%> }
      .frmheader { <%#GetLocalizedText("Stylefrmheader")%> }
      .frmtext { <%#GetLocalizedText("Stylefrmtext")%> }
      .frmInput { <%#GetLocalizedText("StylefrmInput")%> }
      .intro { <%#GetLocalizedText("Styleintro")%> }
   </style>

   <link href="../StyleSheets/Default.css" rel="Stylesheet" type="text/css" />
   <link id="StyleCustom" href="../StyleSheets/WsdlHelpGenerator.css" rel="Stylesheet" type="text/css" runat="server" />

   <title><%#ServiceName + " " + GetLocalizedText("WebService")%></title>
</head>
<body id="WsdlHelpGenerator">
    <div class="heading1">
      <div class="Left">
         <div class="Right">
            <div class="Center">
               <span class="ServiceName"><%#ServiceName%></span>
            </div>
         </div>
      </div>
      
    </div>
    <div id="content">
      <span id="Span1" visible='<%#ShowingMethodList && ServiceDocumentation.Length > 0%>' runat=server>
          <p class="intro"><%#ServiceDocumentation%></p>
      </span>

      <span id="Span2" visible='<%#ShowingMethodList%>' runat=server>

          <p class="intro"><%#GetLocalizedText("OperationsIntro", new object[] { EscapedFileName + "?WSDL" })%> </p>
          
          <asp:repeater id="MethodList" runat=server>
      
            <headertemplate>
              <ul>
            </headertemplate>
      
            <itemtemplate>
              <li>
                <a href="<%#EscapedFileName%>?op=<%#EscapeParam(DataBinder.Eval(Container.DataItem, "Key").ToString())%>"><%#System.Xml.XmlConvert.DecodeName((string)DataBinder.Eval(Container.DataItem, "Value.Name"))%></a>
                <span id="Span3" visible='<%#((string)DataBinder.Eval(Container.DataItem, "Key")) != (string)DataBinder.Eval(Container.DataItem, "Value.Name") %>' runat=server>
                  <br />MessageName="<%#DataBinder.Eval(Container.DataItem, "Key")%>"
                </span>
                <span id="Span4" visible='<%#((string)DataBinder.Eval(Container.DataItem, "Value.Documentation")).Length>0%>' runat=server>
                  <br /><%#DataBinder.Eval(Container.DataItem, "Value.Documentation")%>
                </span>
              </li>
              <p>
            </itemtemplate>
            <footertemplate>
              </ul>
            </footertemplate>
      
          </asp:repeater>
      </span>

      <span id="Span5" visible='<%#!ShowingMethodList && OperationExists%>' runat=server>
          <p class="intro"><%#GetLocalizedText("LinkBack", new object[] { EscapedFileName })%></p>
          <h2><%#OperationName%></h2>
          <p class="intro"><%# SoapOperationBinding == null ? "" : SoapOperation.Documentation%></p>

          <h3><%#GetLocalizedText("TestHeader")%></h3>
          
          <% if (!showPost) { 
                 if (!ShowingHttpGet) { %>
                     <%#GetLocalizedText("NoHttpGetTest")%>
              <% }
                 else {
                     if (!ShowGetTestForm) { %>
                        <%#GetLocalizedText("NoTestNonPrimitive")%>
                  <% }
                     else { %>

                      <%#GetLocalizedText("TestText")%>

                      <form target="_blank" action='<%#TryGetUrl == null ? "" : TryGetUrl.AbsoluteUri%>' method="GET">
                        <asp:repeater ID="Repeater1" datasource='<%#TryGetMessageParts%>' runat=server>

                        <headertemplate>
                           <table cellspacing="0" cellpadding="4" frame="box" bordercolor="#dcdcdc" rules="none" style="border-collapse: collapse;">
  						   <tr id="Tr1" visible='<%# TryGetMessageParts.Length > 0%>' runat=server>
                            <td class="frmHeader" background="#dcdcdc" style="border-right: 2px solid white;"><%#GetLocalizedText("Parameter")%></td>
                            <td class="frmHeader" background="#dcdcdc"><%#GetLocalizedText("Value")%></td>
                          </tr>
                        </headertemplate>

                        <itemtemplate>
                          <tr>
                            <td class="frmText" style="color: #000000; font-weight:normal;"><%# System.Xml.XmlConvert.DecodeName(((System.Web.Services.Description.MessagePart)Container.DataItem).Name) %>:</td>
                            <td><input class="frmInput" type="text" size="50" name="<%# System.Xml.XmlConvert.DecodeName(((System.Web.Services.Description.MessagePart)Container.DataItem).Name) %>"></td>
                          </tr>
                        </itemtemplate>

                        <footertemplate>
                          <tr>
                            <td></td>
                            <td align="right"> <input type="submit" value="<%#GetLocalizedText("InvokeButton")%>" class="button"></td>
                          </tr>
                          </table>
                        </footertemplate>
                    </asp:repeater>

                      </form>
                  <% } 
                 }
             }
             else { // showPost
                 if (!ShowingHttpPost) { 
                    if (requestIsLocal) { %>
                        <%#GetLocalizedText("NoTestNonPrimitive")%>
                 <% }
                    else { %>
                        <%#GetLocalizedText("NoTestFormRemote")%>
                 <% }
                 }
                 else {
                     if (!ShowPostTestForm) { %>
                        <%#GetLocalizedText("NoTestNonPrimitive")%>
                     
                  <% }
                     else { %>                      

                    
                      <%#GetLocalizedText("TestText")%>



                      <form target="_blank" action='<%#TryPostUrl == null ? "" : TryPostUrl.AbsoluteUri%>' method="POST">                      
                        <asp:repeater ID="Repeater2" datasource='<%#TryPostMessageParts%>' runat=server>

                        <headertemplate>
                          <table cellspacing="0" cellpadding="4" frame="box" bordercolor="#dcdcdc" rules="none" style="border-collapse: collapse;">
                          <tr id="Tr2" visible='<%# TryPostMessageParts.Length > 0%>' runat=server>
                            <td class="frmHeader" background="#dcdcdc" style="border-right: 2px solid white;"><%#GetLocalizedText("Parameter")%></td>
                            <td class="frmHeader" background="#dcdcdc"><%#GetLocalizedText("Value")%></td>
                          </tr>
                        </headertemplate>

                        <itemtemplate>
                          <tr>
                            <td class="frmText" style="color: #000000; font-weight: normal;"><%# System.Xml.XmlConvert.DecodeName(((System.Web.Services.Description.MessagePart)Container.DataItem).Name) %>:</td>
                            <td><input class="frmInput" type="text" size="50" name="<%# System.Xml.XmlConvert.DecodeName(((System.Web.Services.Description.MessagePart)Container.DataItem).Name) %>"></td>
                          </tr>
                        </itemtemplate>                        
						
                        <footertemplate>
                        <tr>
                          <td></td>
                          <td align="right"> <input type="submit" value="<%#GetLocalizedText("InvokeButton")%>" class="button"></td>
                        </tr>
                        </table>
                      </footertemplate>
                    </asp:repeater>

                    </form>
                  <% }
                 }
             } %>
          <span id="Span6" visible='<%#ShowingSoap%>' runat=server>
              <h3><%#GetLocalizedText("SoapTitle")%></h3>
              <p><%#GetLocalizedText("SoapText")%></p>

              <pre><%#GetSoapOperationInput(false)%></pre>

              <pre><%#GetSoapOperationOutput(false)%></pre>
          </span>

          <span id="Span7" visible='<%#ShowingSoap12%>' runat=server>
              <h3><%#GetLocalizedText("Soap1_2Title")%></h3>
              <p><%#GetLocalizedText("Soap1_2Text")%></p>

              <pre><%#GetSoapOperationInput(true)%></pre>

              <pre><%#GetSoapOperationOutput(true)%></pre>
          </span>

          <span id="Span8" visible='<%#ShowingHttpGet%>' runat=server>
              <h3><%#GetLocalizedText("HttpGetTitle")%></h3>
              <p><%#GetLocalizedText("HttpGetText")%></p>

              <pre><%#HttpGetOperationInput%></pre>

              <pre><%#HttpGetOperationOutput%></pre>
          </span>

          <span id="Span9" visible='<%#ShowingHttpPost%>' runat=server>
              <h3><%#GetLocalizedText("HttpPostTitle")%></h3>
              <p><%#GetLocalizedText("HttpPostText")%></p>

              <pre><%#HttpPostOperationInput%></pre>

              <pre><%#HttpPostOperationOutput%></pre>
          </span>

      </span>
      

    <span id="Span10" visible='<%#ShowingMethodList%>' runat=server>
        <span id="Span11" visible='<%#Warnings.Count > 0%>' runat=server>
            <hr />
            <h3><font class="error"><%#GetLocalizedText("ServiceConformance")%></font></h3>
            <p class="intro"><%#GetLocalizedText("ServiceConformanceDetails")%></p>
            <p class="intro"><%#GetLocalizedText("ServiceConformanceConfig")%></p>
            <pre>&lt;configuration&gt;
  &lt;system.web&gt;
    &lt;webServices&gt;
      &lt;conformanceWarnings&gt;
        &lt;<font class=value>remove name='BasicProfile1_1'</font>/&gt;
      &lt;/conformanceWarnings&gt;
    &lt;/webServices&gt;
  &lt;/system.web&gt;
&lt;/configuration&gt;</pre>

        <h3><%#GetLocalizedText("ServiceConformanceList")%></h3>
        
        <asp:repeater ID="Repeater3" datasource='<%#Warnings%>' runat=server>
            <itemtemplate>
                <br /><font class=error><%#((System.Web.Services.Description.BasicProfileViolation)Container.DataItem).NormativeStatement%></font>: <%#((System.Web.Services.Description.BasicProfileViolation)Container.DataItem).Details%>
                
                <asp:repeater ID="Repeater4" datasource='<%#((System.Web.Services.Description.BasicProfileViolation)Container.DataItem).Elements%>' runat=server>
                    <itemtemplate>
                        <br />  
                        -  <%#Container.DataItem%>
                    </itemtemplate>   
                </asp:repeater>

                <span id="Span12" visible='<%#((System.Web.Services.Description.BasicProfileViolation)Container.DataItem).Recommendation != null%>' runat=server>
                    <br /><font class=key><%#GetLocalizedText("Recommendation")%>:</font> <%#((System.Web.Services.Description.BasicProfileViolation)Container.DataItem).Recommendation%>
                </span>
                <br />                
            </itemtemplate>
        </asp:repeater>
        <br />
            <p class="intro"><%#GetLocalizedText("ServiceConformanceHelp")%></p>
        </span>
    </span>
    
      <span id="Span13" visible='<%#ShowingMethodList && ServiceNamespace == "http://tempuri.org/"%>' runat=server>
          <hr/>
          <h3><%#GetLocalizedText("DefaultNamespaceWarning1")%></h3>
          <h3><%#GetLocalizedText("DefaultNamespaceWarning2")%></h3>
          <p class="intro"><%#GetLocalizedText("DefaultNamespaceHelp1")%></p>
          <p class="intro"><%#GetLocalizedText("DefaultNamespaceHelp2")%></p>
          <p class="intro"><%#GetLocalizedText("DefaultNamespaceHelp3")%></p>
          <p class="intro">C#</p>
          <pre>[WebService(Namespace="http://microsoft.com/webservices/")]
public class MyWebService {
    // <%#GetLocalizedText("Implementation")%>
}</pre>
          <p class="intro">Visual Basic</p>
          <pre>&lt;WebService(Namespace:="http://microsoft.com/webservices/")&gt; Public Class MyWebService
    ' <%#GetLocalizedText("Implementation")%>
End Class</pre>

          <p class="intro">C++</p>
          <pre>[WebService(Namespace="http://microsoft.com/webservices/")]
public ref class MyWebService {
    // <%#GetLocalizedText("Implementation")%>
};</pre>
          <p class="intro"><%#GetLocalizedText("DefaultNamespaceHelp4")%></p>
          <p class="intro"><%#GetLocalizedText("DefaultNamespaceHelp5")%></p>
          <p class="intro"><%#GetLocalizedText("DefaultNamespaceHelp6")%></p>
      </span>

      <span id="Span14" visible='<%#!ShowingMethodList && !OperationExists%>' runat=server>
          <%#GetLocalizedText("LinkBack", new object[] { EscapedFileName })%>
          <h2><%#GetLocalizedText("MethodNotFound")%></h2>
          <%#GetLocalizedText("MethodNotFoundText", new object[] { Server.HtmlEncode(OperationName), ServiceName })%>
      </span>

    
  </body>
</html>
