﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="CadBoxDialogControl.ascx.cs" Inherits="ccPublisherWeb.Controls.CadBoxDialogControl" %>

<%@ Register Assembly="ccPublisherWeb" Namespace="ccPublisherWeb" TagPrefix="ccPublisherWeb" %>
<%@ Register TagPrefix="asp" Namespace="System.Web.UI" Assembly="System.Web" %>

<asp:PlaceHolder ID="CadBoxDialogPlaceHolder" runat="server">
    <script language="javascript" type="text/javascript">
        var cadboxDialogDefaults = {
            width: <%# CadBoxDialogDisplayMinWidth %>,
            height: <%# CadBoxDialogDisplayMinHeight %>,
            minWidth: <%# CadBoxDialogDisplayMinWidth %>,
            minHeight: <%# CadBoxDialogDisplayMinHeight %>,
            left: -1,
            top: -1,
            maximized: false
        };

        var cadboxdialogactive = false;
        var dialogOptions = { };
            
        function openCadBoxDialog(sender, url, reloadonclose) {
            var dialogOptions = {
                autoOpen: true,
                closeOnEscape: true,
                title: "<%# ccPublisherWeb.TextDic.TxGet("Text_ccRubrikCADVorschauAusgabe") %>",
                width: Math.min(cadboxDialogDefaults.width, $(window).width() * 0.9),
                height: Math.min(cadboxDialogDefaults.height, $(window).height() * 0.9),
                minWidth: cadboxDialogDefaults.minWidth,
                minHeight: cadboxDialogDefaults.minHeight,
                modal: true,
                resizable: true,
                draggable: true,
                autofit: true,
                open: function () {
                    $("#CadBoxDialog .SizeFrame").css("width", "100%");
                    $("#CadBoxDialog .SizeFrame").css("height", "100%");
                    $("#CadBoxDialog .SizeFrame iframe").css("width", "100%");
                    $("#CadBoxDialog .SizeFrame iframe").css("height", "100%");
                    $("#CadBoxDialog .SizeFrame iframe").attr("src", url);
                    
                    cadboxdialogactive = true;
                },
                close: function() {
                    //BEGIN - 20131010 - CAL
                    //move iframe target to about:blank to prevent multiple if dialog open event is fired
                    $("#CadBoxDialog .SizeFrame iframe").attr("src", 'about:blank');
                    //END - 20131010 - CAL
                    $("#CadBoxDialog").dialog("destroy");
                    
                    if (reloadonclose) {
                        if ($('form').length) {
                            $('form')[0].submit();
                        } else {
                            location.reload(true);
                        }
                    }

                    cadboxdialogactive = false;
                },
                resizeStart: function() {
                    $("#CadBoxDialog .SizeFrame").hide();
                },
                resizeStop: function() {
                    cadboxDialogDefaults.width = $("#CadBoxDialog").width();
                    cadboxDialogDefaults.height = $("#CadBoxDialog").height();
                    $("#CadBoxDialog .SizeFrame").show();
                },
                dragStart: function() {
                    $("#CadBoxDialog .SizeFrame").hide();
                },
                dragStop: function() {
                    cadboxDialogDefaults.left = $("#CadBoxDialog").parents(".ui-dialog").eq(0).position().left;
                    cadboxDialogDefaults.top = $("#CadBoxDialog").parents(".ui-dialog").eq(0).position().top;
                    $("#CadBoxDialog .SizeFrame").show();
                },
                onAutoFit:
                    function() {
                        if ($("#CadBoxDialog").dialogExtend("state") != "maximized") {
                            cadboxDialogDefaults.left = $("#CadBoxDialog").parents(".ui-dialog").eq(0).position().left;
                            cadboxDialogDefaults.top = $("#CadBoxDialog").parents(".ui-dialog").eq(0).position().top;
                        }
                    }
            };

            // dialog-extend options
            var dialogExtendOptions = {
                close: true,
                maximize: true,
                dblclick: "maximize",
                strings: {
                    buttonClose: "<%# ccPublisherWeb.TextDic.TxGet("AppletViewer_ButtonClose") %>",
                    buttonMaximize: "<%# ccPublisherWeb.TextDic.TxGet("AppletViewer_ButtonMaximize") %>",
                    buttonRestore: "<%# ccPublisherWeb.TextDic.TxGet("AppletViewer_ButtonRestore") %>"
                },
                events : {
                    maximize:
                        function() {
                            cadboxDialogDefaults.left = 0;
                            cadboxDialogDefaults.top = 0;
                            cadboxDialogDefaults.maximized = true;
                        },
                    restore:
                        function() {
                            cadboxDialogDefaults.left = -1;
                            cadboxDialogDefaults.top = -1;
                            cadboxDialogDefaults.maximized = false;
                        }
                }
            };
                
            // open dialog
            $("#CadBoxDialog").dialog(dialogOptions).dialogExtend(dialogExtendOptions);
                
            if(cadboxDialogDefaults.maximized) {
                $("#CadBoxDialog").dialogExtend("maximize");
            }

            if(cadboxDialogDefaults.left > -1 || cadboxDialogDefaults.top > -1) {
                $("#CadBoxDialog")
                    .parents(".ui-dialog").eq(0)
                    .css("left", cadboxDialogDefaults.left + "px")
                    .css("top", cadboxDialogDefaults.top + "px");
            }
        }
    </script>
    <div id="CadBoxDialog" style="display: none; overflow: hidden;">
        <div class="SizeFrame" style="overflow: hidden; width:100%; height:100%;">
            <iframe src="#" marginheight="0" marginwidth="0" border="0" frameborder="0" style="width:100%; height:100%"></iframe>
        </div>
    </div>
</asp:PlaceHolder>